#include <hidef.h> /* for EnableInterrupts macro */
#include "derivative.h" /* include peripheral declarations */
#include "initial_setting.h"
#include "iic.h"

#define i2c_Start()            IICC1     |= 0x10;\
                               IICC1_MST  = 1

#define i2c_Stop()             IICC1_MST  = 0;\
                               IICC1_TX   = 0

#define i2c_write_byte(data)   IICD = data

unsigned char SlaveID;
unsigned char IIC_TempByte;
unsigned int IIC_TxBuffer[256];
unsigned int IIC_RxBuffer[256];



/*The IIC slave used is EEPROM "AT24C01B"*/

unsigned char IIC_EEPROM_Comm(void);  //a sample function for communication between IIC and EEPROM

void iic_sample_callback(void) 
{
 return;
}

unsigned char IIC_EEPROM_Comm() {
 
  unsigned char IIC_TempByte;
  unsigned char IIC_TxByte[4]={0xaa,0xbb,0xcc,0xdd};
  unsigned char IIC_RxByte[4];
  unsigned int j;
  
  //IIC master address 
  IICA = 0xAA;
  
  //EEPROM address is 0x50
  //send start signal
  //send control word plus Write bit
  IIC_Start_Transmission(0x50,MWSR);
  
  //poll for transaction done
  // poll for ACK Receive  
   IIC_Wait_Ack();
  
  //page address
  IIC_Write_Byte(0x08);
  
  //poll for transaction done
  // poll for ACK Receive 
  IIC_Wait_Ack();

  
  //writing data
  for (j=0; j<4; j++) 
    {
      
         IIC_Write_Byte(IIC_TxByte[j]);
     
         //poll for transaction done
         // poll for ACK Receive 
         IIC_Wait_Ack();
    }
 
  //sends stop signal
  IIC_Send_Stop();
 
  for(j=0;j<0xFFFE;j++); //delay
  
  //EEPROM address is 0x50
  //send start signal
  //send control word plus Write bit
  IIC_Start_Transmission(0x50,MWSR);  
     
  //poll for transaction done
  // poll for ACK Receive 
  IIC_Wait_Ack();

  
  //page address from where the data is to be read 
  IIC_Write_Byte(0x08);            
  
  //poll for transaction done
  // poll for ACK Receive 
  IIC_Wait_Ack();
 
  
  //repeated start
  IIC_Repeated_Start();
  
  IIC_Write_Byte(0xA0|MRSW);
  
  //poll for transaction done
  // poll for ACK Receive 
   IIC_Wait_Ack();
 
  
   //setting receive mode  
   IIC_Enter_RxMode();
 
   //dummy read 
   IIC_TempByte = IICD;                                
  

   while(!IICS_IICIF);              //poll for transfer complete bit
   IICS_IICIF =1;                   //clear IICIF BIT
  
   //receiving data
   for(j=0;j<4;j++) 
      {
        if(j==3)
        IICC1_TXAK = 1;             //Stop the ack sent by master after the last byte is read
        
        IIC_RxByte[j] = IICD;       //data read from the location EEPROM location 0x08 
        
        while(!IICS_IICIF);         //poll for transfer complete bit
      
        IICS_IICIF =1;              //clear IICIF BIT
      }

  //send STOP signal 
  IIC_Send_Stop();
  

  // comparing sent and received data
  for(j=0;j<4; j++) 
  {
    if(!(IIC_TxByte[j] == IIC_RxByte[j])) 
    {
      return 0;
    }
  }
  return 1;
 
}

void main(void) {

  EnableInterrupts; /* enable interrupts */
  /* include your code here */
  
  /*configures the clock settings*/
  InitConfig();
  
  /*enables fcd for LCD pins*/
  fcd_enable_on_lcd_pins();
  
   
  /*initializes the IIC*/
  IIC_Init(IIC_INTERRUPT_DISABLE,IIC_7_BIT_SLAVE_ADDR,&iic_sample_callback);
  
  /*communicates between IIC and EEPROM*/
  if(IIC_EEPROM_Comm()) 
  {
    /*success*/
  } 
  else
  {
    /*fail*/
  }
                       
  for(;;) {
    __RESET_WATCHDOG(); /* feeds the dog */
  } /* loop forever */
  /* please make sure that you never leave main */
}



